## ✔️ 지문을 이해하는 게 가장 어려운(?) 문제

---

문제를 쉽게 요약하면 아래와 같다.

1. 방향 그래프가 주어진다.
2. 출발지와 목적지 후보들이 주어진다.
3. 교차로가 주어진다.

이때,

1. 예술가 듀오들은 항상 최단 경로로만 이동하며
2. 교차로를 반드시 거쳐서 이동한다.

이러한 상황에서, 목적지 후보 중 불가능한 것을 제거하여 출력하면 된다.

---



## 아이디어

출발지로부터 목적지 후보까지의 최단 경로와
출발지에서 교차로를 거쳐서 목적지 후보로 도달하는 최단 경로를 비교해서

출발지에서 교차로를 거쳐서 목적지 후보로 도달하는 최단 경로 <= 출발지로부터 목적지 후보까지의 최단 경로  이면

목적지 후보는 **목적지가 될 수 있으므로 정답 배열에 추가.**

이때 교차로 g-h 가 주어지면 (출발지는 s, 목적지 후보는 x)

출발지에서 교차로를 거쳐서 목적지 후보로 도달하는 최단 경로는
1. s 에서 g 까지의 최단 경로 + g 에서 h 까지의 최단경로 + h 에서 x 까지의 최단경로
2. s 에서 h 까지의 최단 경로 + h 에서 g 까지의 최단경로 + g 에서 x 까지의 최단경로
위 1, 2 중 작은 값이다.

출발지로부터 목적지 후보까지의 최단경로는 단순히 s 에서부터 x 까지의 최단경로를 계산해주면 된다.

생각해보자.

위를 쉽게 구하기 위해서는 단일 노드에 대해서 모든 노드까지의 최단 경로를 담은 dist 배열이 있으면 좋을 것이고,

이는 Dijkstra 를 통해서 얻을 수 있다.

다만 Dijkstra 는 모든 가중치가 음수가 아니여야하는데, 위 문제에서 모든 가중치는 양수이므로 사용이 가능하다. (음의 간선이 존재한다면 벨만-포드로 해결 가능하다.)

이제 시간 복잡도를 계산해보고 Dijkstra 를 사용했을 때, 문제가 없을 것 같다면 구현하면 정답을 받을 수 있다. 

---



## 시간복잡도 체크

일단, 시간 제한은 3초이고
최대 테스트 케이스는 100개
최대 노드 개수는 2000 개
최대 엣지 개수는 50,000 개

다익스트라를 일반적으로 구현하면, O(V^2) 의 시간이 소요되지만

우선순위큐를 활용하여  최적화한다면, O(ElogV) 가 소요된다.

그렇다면, 한 번의 Dijkstra 에서는 최대 50,000 * log 2000 ~= 165,000 이고

위 아이디어로 풀이하기 위해서는 총 3번의 Dijkstra 가 필요하다. (s, g, h)

그리고 이를 Test case 만큼 반복하므로,

최대 49,500,000 정도의 연산이 필요하므로

시간 제한 3초 내에 아주 넉넉하게 작동할 것임을 알 수 있다.
